import matplotlib.pyplot as plt

def draw(
        values:list
):
    bar_width = 0.4
    offset = 9

    positions = []
    for i in range(3):
        for j in range(10):
            positions.append((i+1)*offset-3*bar_width+j*2*bar_width)

    color = ['#008000', '#F0E68C', '#808080','#000080' ,'#ADD8E6','#D2B48C','#808000','#DAA520','#C1F80A','#D2691E']
    plt.bar(positions, values, color=color, edgecolor='black', linewidth=2)

    legend_labels = ['OWA', 'R', 'Ada','GOK','EAE','UCB','MOT','MPC', 'S-OWA','A-OWA']
    legend_handles = [plt.Line2D([0], [0], color=color, linewidth=3, linestyle='-') for color in
                      color]
    plt.legend(legend_handles, legend_labels, loc='upper center', bbox_to_anchor=(0.5, 1.15),
               fancybox=True, shadow=True, ncol=5, fontsize=10)

    plt.xlabel(r"$K$ (kJ)", fontsize=12)
    plt.ylabel(r"Accumulated Accuracy", fontsize=12)
    plt.ylim(100, 360)

    plt.grid(axis='y', linestyle='--', alpha=0.7)

    plt.xticks([(i+1.275)*offset for i in range(3)], ['10', '11', '12'],fontsize=10)
    figure = plt.gcf()
    figure.savefig("Set2-4.pdf")
    plt.show()

if __name__ == '__main__':
    OWA = [333.55309985977186, 0.0, 348.31812278451775, 0.0, 0.0, 350.32261431391277]
    Random = [271.34718383854494, 0.0, 272.7145529248304, 0.0, 0.0, 267.14787370499124]
    Adaptive = [326.1198784142977, 0.0, 343.11286351207366, 0.0, 0.0, 346.9057741873156]
    SingleOLS = [254.70099205630828, 0.0, 275.68225071586016, 0.0, 0.0, 294.1523355142758]
    MAB = [137.56032633809693, 0.0, 137.56032633809693, 0.0, 0.0, 137.56032633809693]
    GOK = [166.01534839233727, 0.0, 166.01534839233727, 0.0, 0.0, 166.01534839233727]
    MPC = [221.09830762636528, 0.0, 276.1812668603933, 0.0, 0.0, 331.26422609442136]
    UBC = [114.59474264908765, 0.0, 114.59474264908765, 0.0, 0.0, 114.59474264908765]
    AvgM = [178.29943271015844, 0.0, 209.3650544300301, 0.0, 0.0, 215.18546570305506]
    OTP = [205.2866809001013,0.0,223.19219155684183,0.0,0.0,249.82415284364131]
    rows = [OWA, Random, Adaptive, GOK, MAB, UBC, OTP, MPC, SingleOLS, AvgM]
    data = []
    for j in range(3):
        if j==0:
            for i in rows:
                data.append(i[0])
        if j==2:
            for i in rows:
                data.append(i[-1])
        if j==1:
            for i in rows:
                data.append((i[2]+i[3])/2)
    print(len(data))
    draw(data)